require 'rubygems'
require 'rspec'
require 'watir-webdriver'
require 'page-object'
require 'oci8'

require_relative '../../module/DriverUtility'
require_relative '../rspec_helper'
require_relative '../../pages/login'
require_relative '../../common/common'
require_relative '../../pages/landing_appointments'
require_relative '../../pages/appointments/new_appointment_request'
require_relative '../../module/database/OracleUtility'
require_relative '../../module/DateUtility'
require_relative '../../module/database/MongoUtility'

describe '[Story# VAR-11344: Location Selection Display Improvements to Support Integrated VistA]'  do

  include DriverUtility
  include OracleUtility
  include DateUtility
  include MongoUtility


  before(:all) do
    initializeConfigurations(VAR_BASE_URL)
    @landing_appointments = LandingAppointments.new(@driver)
    @login = Login.new(@driver)
    @common = Common.new(@driver)
    @new_appointment = NewAppointmentRequest.new(@driver)
    TITLE = "Appointments/Requests"

    @patientID ="1113138327"

    #mongo
    @db = connectToMongoDB("var-utility")
    restoreCollection("siteSupportingVAR", "var-utility", "sites-supporting-var-exported2.json", @db)
    restoreCollection("clinical-services", "var-utility", "clinical_services_default.json", @db)
    restoreCollection("directBookingEligibilityCriteria", "var-utility", "directSchedulingEnabled.json", @db)
    restoreCollection("requestEligibilityCriteria", "var-utility", "requestEligibilityCriteria.json", @db)
    restoreCollection("custom-friendly-text", "var-utility", "facility_friendly_name.json", @db)
    deletePatientData(@patientID)
    @common.loginEndsOnHome(pw_redacted)
    @landing_appointments.appointment_header_element.wait_until_present(TIME_OUT_LIMIT)
    @common.selectAddAppointmentButton("VA")
  end

  after(:all) do
    @driver.close
  end

  context 'AC#VAR-11736|TC#VAR-11738: Location Selection Display Improvements to Support Integrated VistA' do

    it "Verify City, State Step2 Multi DFN" do
      @new_appointment.selectTypeOfCare(PRIMARY_CARE)
      expected_content =[\
                        "Step 2: City, State",
                        "* Choose the closest city and state for this appointment:",
                        "Select",
                        "Des Moines, IA",
                        "Iowa City, IA",
                        "BOSTON, MA",
                        "Omaha, NE"
      ]

      actual_content = @new_appointment.city_state_section_element.text.split("\n")
      compareContents( expected_content, actual_content)
    end

    it "Verify City, State Step2 Single DFN" do
      @new_appointment.cancelForm
      @common.logoutAndLogbackWithADifferentUser(MockUser03)
      @common.selectAddAppointmentButton("VA")
      @new_appointment.selectTypeOfCare(PRIMARY_CARE)
      expected_content =[\
                        "Step 2: City, State",
                        "* Choose the closest city and state for this appointment:",
                        "Select",
                        "BOSTON, MA"
      ]

      actual_content = @new_appointment.city_state_section_element.text.split("\n")
      compareContents( expected_content, actual_content)

    end

    it "Verify Step 3: Select Location displayed with Single DFN" do
      expected_content =[\
                        "Step 3: Location",
                        "The following facility locations support scheduling #{PRIMARY_CARE} appointments through this app. If you cannot find the location you need, please visit the VA Facility Locator to contact the facility for assistance.",
                        "* Select the location you want to visit:",
                        "Select",
                        "BOSTON HCS VAMC (BOSTON, MA)",
                        "BROCKTON VAMC (BROCKTON, MA)",
                        "QUINCY (QUINCY, MA)"
      ]

      actual_content = @new_appointment.facility_section_element.text.split("\n")

      compareContents( expected_content, actual_content)
    end

  end

end